;************************************************************************
;*
;* Copyright:
;*	Freescale Semiconductor, INC. All Rights Reserved.  
;*  You are hereby granted a copyright license to use, modify, and
;*  distribute the SOFTWARE so long as this entire notice is
;*  retained without alteration in any modified and/or redistributed
;*  versions, and that such modified versions are clearly identified
;*  as such. No licenses are granted by implication, estoppel or
;*  otherwise under any patents or trademarks of Freescale Semiconductor, 
;*  Inc. This software is provided on an "AS IS" basis and without warranty.
;*
;*  To the maximum extent permitted by applicable law, FREESCALE 
;*  DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED, INCLUDING 
;*  IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR
;*  PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH REGARD TO THE 
;*  SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF) AND ANY 
;*  ACCOMPANYING WRITTEN MATERIALS.
;* 
;*  To the maximum extent permitted by applicable law, IN NO EVENT
;*  SHALL FREESCALE BE LIABLE FOR ANY DAMAGES WHATSOEVER (INCLUDING 
;*  WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS, BUSINESS 
;*  INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER PECUNIARY
;*  LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.   
;* 
;*  Freescale assumes no responsibility for the maintenance and support
;*  of this software
;*************************************************************************
;*
;*  FILE NAME : fft32.s
;*
;*  PURPOSE   : contains optimized versions of init_data32(), fft32() and 
;*              inv_fft32() functions  
;*
;*  AUTHORS   : Anatoly Khaynakov and Andriy Tymkiv
;*
;*************************************************************************
	.section .data,4,r
#define __EMAC_H

TF_table:

.long -2147483648,0,-2147443223,-13176712,-2147321947,
.long -26352928,-2147119826,-39528152,-2146836867,-52701887,
.long -2146473080,-65873639,-2146028480,-79042910,-2145503084,
.long -92209205,-2144896910,-105372029,-2144209983,-118530885,
.long -2143442327,-131685279,-2142593971,-144834715,-2141664949,
.long -157978698,-2140655293,-171116733,-2139565043,-184248326,
.long -2138394240,-197372982,-2137142928,-210490207,-2135811153,
.long -223599507,-2134398966,-236700388,-2132906420,-249792358,
.long -2131333572,-262874924,-2129680480,-275947592,-2127947207,
.long -289009871,-2126133818,-302061269,-2124240381,-315101295,
.long -2122266967,-328129457,-2120213652,-341145266,-2118080511,
.long -354148230,-2115867626,-367137861,-2113575080,-380113669,
.long -2111202959,-393075167,-2108751352,-406021865,-2106220352,
.long -418953277,-2103610054,-431868915,-2100920557,-444768294,
.long -2098151960,-457650928,-2095304370,-470516331,-2092377893,
.long -483364020,-2089372638,-496193510,-2086288720,-509004319,
.long -2083126255,-521795964,-2079885361,-534567963,-2076566160,
.long -547319837,-2073168778,-560051104,-2069693342,-572761286,
.long -2066139984,-585449903,-2062508836,-598116479,-2058800036,
.long -610760536,-2055013724,-623381598,-2051150041,-635979190,
.long -2047209134,-648552838,-2043191150,-661102069,-2039096242,
.long -673626409,-2034924562,-686125387,-2030676269,-698598533,
.long -2026351522,-711045378,-2021950484,-723465452,-2017473321,
.long -735858288,-2012920201,-748223419,-2008291296,-760560380,
.long -2003586780,-772868706,-1998806830,-785147935,-1993951625,
.long -797397603,-1989021350,-809617249,-1984016189,-821806414,
.long -1978936331,-833964638,-1973781968,-846091464,-1968553292,
.long -858186435,-1963250502,-870249096,-1957873796,-882278992,
.long -1952423377,-894275671,-1946899451,-906238681,-1941302225,
.long -918167572,-1935631911,-930061895,-1929888720,-941921201,
.long -1924072871,-953745044,-1918184581,-965532979,-1912224073,
.long -977284562,-1906191571,-988999352,-1900087301,-1000676906,
.long -1893911495,-1012316785,-1887664383,-1023918550,-1881346202,
.long -1035481766,-1874957190,-1047005997,-1868497586,-1058490808,
.long -1861967635,-1069935768,-1855367581,-1081340446,-1848697674,
.long -1092704411,-1841958165,-1104027237,-1835149307,-1115308497,
.long -1828271356,-1126547766,-1821324573,-1137744621,-1814309217,
.long -1148898641,-1807225553,-1160009405,-1800073849,-1171076496,
.long -1792854373,-1182099496,-1785567397,-1193077991,-1778213195,
.long -1204011567,-1770792045,-1214899813,-1763304225,-1225742319,
.long -1755750018,-1236538676,-1748129707,-1247288478,-1740443581,
.long -1257991320,-1732691928,-1268646800,-1724875040,-1279254516,
.long -1716993212,-1289814069,-1709046740,-1300325061,-1701035923,
.long -1310787096,-1692961063,-1321199781,-1684822464,-1331562724,
.long -1676620432,-1341875534,-1668355277,-1352137823,-1660027309,
.long -1362349205,-1651636842,-1372509295,-1643184191,-1382617711,
.long -1634669676,-1392674072,-1626093616,-1402678000,-1617456335,
.long -1412629118,-1608758158,-1422527051,-1599999412,-1432371427,
.long -1591180426,-1442161875,-1582301534,-1451898026,-1573363069,
.long -1461579514,-1564365367,-1471205975,-1555308768,-1480777045,
.long -1546193613,-1490292365,-1537020244,-1499751576,-1527789008,
.long -1509154323,-1518500250,-1518500250,-1509154323,-1527789008,
.long -1499751576,-1537020244,-1490292365,-1546193613,-1480777045,
.long -1555308768,-1471205975,-1564365367,-1461579514,-1573363069,
.long -1451898026,-1582301534,-1442161875,-1591180426,-1432371427,
.long -1599999412,-1422527051,-1608758158,-1412629118,-1617456335,
.long -1402678000,-1626093616,-1392674072,-1634669676,-1382617711,
.long -1643184191,-1372509295,-1651636842,-1362349205,-1660027309,
.long -1352137823,-1668355277,-1341875534,-1676620432,-1331562724,
.long -1684822464,-1321199781,-1692961063,-1310787096,-1701035923,
.long -1300325061,-1709046740,-1289814069,-1716993212,-1279254516,
.long -1724875040,-1268646800,-1732691928,-1257991320,-1740443581,
.long -1247288478,-1748129707,-1236538676,-1755750018,-1225742319,
.long -1763304225,-1214899813,-1770792045,-1204011567,-1778213195,
.long -1193077991,-1785567397,-1182099496,-1792854373,-1171076496,
.long -1800073849,-1160009405,-1807225553,-1148898641,-1814309217,
.long -1137744621,-1821324573,-1126547766,-1828271356,-1115308497,
.long -1835149307,-1104027237,-1841958165,-1092704411,-1848697674,
.long -1081340446,-1855367581,-1069935768,-1861967635,-1058490808,
.long -1868497586,-1047005997,-1874957190,-1035481766,-1881346202,
.long -1023918550,-1887664383,-1012316785,-1893911495,-1000676906,
.long -1900087301,-988999352,-1906191571,-977284562,-1912224073,
.long -965532979,-1918184581,-953745044,-1924072871,-941921201,
.long -1929888720,-930061895,-1935631911,-918167572,-1941302225,
.long -906238681,-1946899451,-894275671,-1952423377,-882278992,
.long -1957873796,-870249096,-1963250502,-858186435,-1968553292,
.long -846091464,-1973781968,-833964638,-1978936331,-821806414,
.long -1984016189,-809617249,-1989021350,-797397603,-1993951625,
.long -785147935,-1998806830,-772868706,-2003586780,-760560380,
.long -2008291296,-748223419,-2012920201,-735858288,-2017473321,
.long -723465452,-2021950484,-711045378,-2026351522,-698598533,
.long -2030676269,-686125387,-2034924562,-673626409,-2039096242,
.long -661102069,-2043191150,-648552838,-2047209134,-635979190,
.long -2051150041,-623381598,-2055013724,-610760536,-2058800036,
.long -598116479,-2062508836,-585449903,-2066139984,-572761286,
.long -2069693342,-560051104,-2073168778,-547319837,-2076566160,
.long -534567963,-2079885361,-521795964,-2083126255,-509004319,
.long -2086288720,-496193510,-2089372638,-483364020,-2092377893,
.long -470516331,-2095304370,-457650928,-2098151960,-444768294,
.long -2100920557,-431868915,-2103610054,-418953277,-2106220352,
.long -406021865,-2108751352,-393075167,-2111202959,-380113669,
.long -2113575080,-367137861,-2115867626,-354148230,-2118080511,
.long -341145266,-2120213652,-328129457,-2122266967,-315101295,
.long -2124240381,-302061269,-2126133818,-289009871,-2127947207,
.long -275947592,-2129680480,-262874924,-2131333572,-249792358,
.long -2132906420,-236700388,-2134398966,-223599507,-2135811153,
.long -210490207,-2137142928,-197372982,-2138394240,-184248326,
.long -2139565043,-171116733,-2140655293,-157978698,-2141664949,
.long -144834715,-2142593971,-131685279,-2143442327,-118530885,
.long -2144209983,-105372029,-2144896910,-92209205,-2145503084,
.long -79042910,-2146028480,-65873639,-2146473080,-52701887,
.long -2146836867,-39528152,-2147119826,-26352928,-2147321947,
.long -13176712,-2147443223,-1,-2147483648,13176711,
.long -2147443223,26352927,-2147321947,39528151,-2147119826,
.long 52701886,-2146836867,65873638,-2146473080,79042909,
.long -2146028480,92209204,-2145503084,105372028,-2144896910,
.long 118530884,-2144209983,131685278,-2143442327,144834714,
.long -2142593971,157978697,-2141664949,171116732,-2140655293,
.long 184248325,-2139565043,197372981,-2138394240,210490206,
.long -2137142928,223599506,-2135811153,236700387,-2134398966,
.long 249792357,-2132906420,262874923,-2131333572,275947591,
.long -2129680480,289009870,-2127947207,302061268,-2126133818,
.long 315101294,-2124240381,328129456,-2122266967,341145265,
.long -2120213652,354148229,-2118080511,367137860,-2115867626,
.long 380113668,-2113575080,393075166,-2111202959,406021864,
.long -2108751352,418953276,-2106220352,431868914,-2103610054,
.long 444768293,-2100920557,457650927,-2098151960,470516330,
.long -2095304370,483364019,-2092377893,496193509,-2089372638,
.long 509004318,-2086288720,521795963,-2083126255,534567962,
.long -2079885361,547319836,-2076566160,560051103,-2073168778,
.long 572761285,-2069693342,585449902,-2066139984,598116478,
.long -2062508836,610760535,-2058800036,623381597,-2055013724,
.long 635979189,-2051150041,648552837,-2047209134,661102068,
.long -2043191150,673626408,-2039096242,686125386,-2034924562,
.long 698598532,-2030676269,711045377,-2026351522,723465451,
.long -2021950484,735858287,-2017473321,748223418,-2012920201,
.long 760560379,-2008291296,772868705,-2003586780,785147934,
.long -1998806830,797397602,-1993951625,809617248,-1989021350,
.long 821806413,-1984016189,833964637,-1978936331,846091463,
.long -1973781968,858186434,-1968553292,870249095,-1963250502,
.long 882278991,-1957873796,894275670,-1952423377,906238680,
.long -1946899451,918167571,-1941302225,930061894,-1935631911,
.long 941921200,-1929888720,953745043,-1924072871,965532978,
.long -1918184581,977284561,-1912224073,988999351,-1906191571,
.long 1000676905,-1900087301,1012316784,-1893911495,1023918549,
.long -1887664383,1035481765,-1881346202,1047005996,-1874957190,
.long 1058490807,-1868497586,1069935767,-1861967635,1081340445,
.long -1855367581,1092704410,-1848697674,1104027236,-1841958165,
.long 1115308496,-1835149307,1126547765,-1828271356,1137744620,
.long -1821324573,1148898640,-1814309217,1160009404,-1807225553,
.long 1171076495,-1800073849,1182099495,-1792854373,1193077990,
.long -1785567397,1204011566,-1778213195,1214899812,-1770792045,
.long 1225742318,-1763304225,1236538675,-1755750018,1247288477,
.long -1748129707,1257991319,-1740443581,1268646799,-1732691928,
.long 1279254515,-1724875040,1289814068,-1716993212,1300325060,
.long -1709046740,1310787095,-1701035923,1321199780,-1692961063,
.long 1331562723,-1684822464,1341875533,-1676620432,1352137822,
.long -1668355277,1362349204,-1660027309,1372509294,-1651636842,
.long 1382617710,-1643184191,1392674071,-1634669676,1402677999,
.long -1626093616,1412629117,-1617456335,1422527050,-1608758158,
.long 1432371426,-1599999412,1442161874,-1591180426,1451898025,
.long -1582301534,1461579513,-1573363069,1471205974,-1564365367,
.long 1480777044,-1555308768,1490292364,-1546193613,1499751575,
.long -1537020244,1509154322,-1527789008,1518500249,-1518500250,
.long 1527789007,-1509154323,1537020243,-1499751576,1546193612,
.long -1490292365,1555308767,-1480777045,1564365366,-1471205975,
.long 1573363068,-1461579514,1582301533,-1451898026,1591180425,
.long -1442161875,1599999411,-1432371427,1608758157,-1422527051,
.long 1617456334,-1412629118,1626093615,-1402678000,1634669675,
.long -1392674072,1643184190,-1382617711,1651636841,-1372509295,
.long 1660027308,-1362349205,1668355276,-1352137823,1676620431,
.long -1341875534,1684822463,-1331562724,1692961062,-1321199781,
.long 1701035922,-1310787096,1709046739,-1300325061,1716993211,
.long -1289814069,1724875039,-1279254516,1732691927,-1268646800,
.long 1740443580,-1257991320,1748129706,-1247288478,1755750017,
.long -1236538676,1763304224,-1225742319,1770792044,-1214899813,
.long 1778213194,-1204011567,1785567396,-1193077991,1792854372,
.long -1182099496,1800073848,-1171076496,1807225552,-1160009405,
.long 1814309216,-1148898641,1821324572,-1137744621,1828271355,
.long -1126547766,1835149306,-1115308497,1841958164,-1104027237,
.long 1848697673,-1092704411,1855367580,-1081340446,1861967634,
.long -1069935768,1868497585,-1058490808,1874957189,-1047005997,
.long 1881346201,-1035481766,1887664382,-1023918550,1893911494,
.long -1012316785,1900087300,-1000676906,1906191570,-988999352,
.long 1912224072,-977284562,1918184580,-965532979,1924072870,
.long -953745044,1929888719,-941921201,1935631910,-930061895,
.long 1941302224,-918167572,1946899450,-906238681,1952423376,
.long -894275671,1957873795,-882278992,1963250501,-870249096,
.long 1968553291,-858186435,1973781967,-846091464,1978936330,
.long -833964638,1984016188,-821806414,1989021349,-809617249,
.long 1993951624,-797397603,1998806829,-785147935,2003586779,
.long -772868706,2008291295,-760560380,2012920200,-748223419,
.long 2017473320,-735858288,2021950483,-723465452,2026351521,
.long -711045378,2030676268,-698598533,2034924561,-686125387,
.long 2039096241,-673626409,2043191149,-661102069,2047209133,
.long -648552838,2051150040,-635979190,2055013723,-623381598,
.long 2058800035,-610760536,2062508835,-598116479,2066139983,
.long -585449903,2069693341,-572761286,2073168777,-560051104,
.long 2076566159,-547319837,2079885360,-534567963,2083126254,
.long -521795964,2086288719,-509004319,2089372637,-496193510,
.long 2092377892,-483364020,2095304369,-470516331,2098151959,
.long -457650928,2100920556,-444768294,2103610053,-431868915,
.long 2106220351,-418953277,2108751351,-406021865,2111202958,
.long -393075167,2113575079,-380113669,2115867625,-367137861,
.long 2118080510,-354148230,2120213651,-341145266,2122266966,
.long -328129457,2124240380,-315101295,2126133817,-302061269,
.long 2127947206,-289009871,2129680479,-275947592,2131333571,
.long -262874924,2132906419,-249792358,2134398965,-236700388,
.long 2135811152,-223599507,2137142927,-210490207,2138394239,
.long -197372982,2139565042,-184248326,2140655292,-171116733,
.long 2141664948,-157978698,2142593970,-144834715,2143442326,
.long -131685279,2144209982,-118530885,2144896909,-105372029,
.long 2145503083,-92209205,2146028479,-79042910,2146473079,
.long -65873639,2146836866,-52701887,2147119825,-39528152,
.long 2147321946,-26352928,2147443222,-13176712



        .section .text,4,c      ; Locate the code in the ".dsp32code" section.

        .align  4
	.xdef	_init_data32
    .xdef   _fft32_emac
	.xdef	_inv_fft32_emac

;******************************************************************************
;Store initial data
;******************************************************************************
;Stores initial data into ReX[] buffer.
;ImX[] buffer contains zeros.
;******************************************************************************
_init_data32:
	movem.l	(4,a7),a0-a1
	move.l	#0,d1
	move.l	#0,d2
nexx:	move.l	d2,(a0)+
	move.l	d1,(a1)+
	addq.l	#1,d2
	cmp.l	#1024,d2
	bcs.b	nexx
	rts

;******************************************************************************
;Bit reversal sorting
;******************************************************************************
;Sorts the samples in ReX[] and Imx[] using bit reversal address mode
;******************************************************************************
;Corresponding C code:
;
;	void RevSort(void){
;	short i,j,k,n=1024,nm1=n-1,nd2=n>>1;
;	float tr,ti;
;
;	j=nd2;
;	for (i=1;i<=n-2;i++){
;		if (i<j){
;			tr=ReX[j];
;			ti=ImX[j];
;			ReX[j]=ReX[i];
;			ImX[j]=ImX[i];
;			ReX[i]=tr;
;			ImX[i]=ti;
;	  	}
;		k=nd2;
; 		while (k<=j){
;			j=j-k;
;			k=k>>1;
; 		}
;  		j=j+k;
;	}
;
;	}


_rev_addr_sort:
	movem.l	(4,a7),a0/a1		;load start addresses of ReX and ImX buffers
					;to a0 and a1 registers
	move.l	#1024,d2		;store nd2*4 into d2 register (d2 is j)
					;'4' is the size of one sample (4 bytes)
	moveq.l	#4,d1			;d1 is i

for:					;for (i=1;i<=n-2;i++){
	cmp.l	d2,d1			;if (i<j){
	bcc.b	jk
	lea	(a0,d1.l),a2		;add index j to the beginning address of buffer ReX
					;and store it into a2
	lea	(a1,d1.l),a3		;add index j to the beginning address of buffer ImX
					;and store it into a3
	move.l	(a0,d2.l),d3		;tr=ReX[j];
	move.l	(a1,d2.l),d4		;ti=ImX[j];
	move.l	(a2),(a0,d2.l)		;ReX[j]=ReX[i];
	move.l	(a3),(a1,d2.l)		;ImX[j]=ImX[i];
	move.l	d3,(a2)			;ReX[i]=tr;
	move.l	d4,(a3)			;ImX[i]=ti;
jk:	
	move.l	#1024,d0		;d0 is k, k=nd2*4
					;'4' is the size of one sample (4 bytes);
	
	cmp.l	d0,d2			;while (k<=j){
	bcs.b	j
while:	sub.l	d0,d2			;j=j-k;
	lsr.l	#1,d0			;k=k>>1;
	cmp.l	d0,d2
	bcc.b	while
j:	
	add.l	d0,d2			;j=j+k;

	addq.l	#4,d1
	cmp.l	#2044,d1
	bcs.b	for
	rts

;**********************************************************************************
;Real FFT
;**********************************************************************************
;Upon entry, ReX[ ] contains the real input signal, while values in ImX[ ] are
;ignored.
;Upon return, ReX[ ] and ImX[ ] contain the DFT output.
;All signals run from 0 to 1023.
;**********************************************************************************
_fft32_emac:
	lea	-72(a7),a7
	movem.l	d0-d7/a0-a6,(a7)	;store contents of all registers into stack

	;Corresponding C code:		;separate even and odd points
	;for (i=0;i<512;i++){
	;    ReX[i]=ReX[2*i];
	;    ImX[i]=ReX[2*i+1];
	;}
	
	movem.l	(76,a7),a0/a1		;separate even and odd points
					;point a0 and a1 to ReX and ImX buffers
	moveq.l	#0,d0			
	movea.l	a0,a2
reorder:
	move.l	(0,a0,d0.l),(a2)+		;ReX[i]=ReX[2*i];
	move.l	(4,a0,d0.l),(a1)+		;ImX[i]=ReX[2*i+1];
	addq.l	#8,d0			;modification of loop counter
	cmpi.l	#4096,d0
	bcs.b	reorder

	lea	-2048(a1),a1		;bit reversal sorting
	move.l	a1,-(a7)		;push address of ImX[] buffer into the stack
	move.l	a0,-(a7)		;push address of ReX[] buffer into the stack
	jsr	_rev_addr_sort		;jump to subroutine
	lea	(8,a7),a7

	moveq.l	#0,d6			;first stage of FFT

    
first_stage:
	movem.l	(a0),d0/d2		;d0 = ar, d2 = br
	movem.l	(a1),d1/d3		;d1 = ai, d3 = bi
					;on the first stage the butterfly operation
					;looks like:
					;xr = ar + br
					;xi = ai + bi
					;yr = ar - br
					;yi = ai - bi
	move.l	d2,d4
	move.l	d3,d5
	add.l	d0,d2			;xr = ar + br
	move.l	d2,(a0)+
	add.l	d1,d3			;xi = ai + bi
	move.l	d3,(a1)+
	sub.l	d4,d0			;yr = ar - br
	move.l	d0,(a0)+
	sub.l	d5,d1			;yi = ai - bi
	move.l	d1,(a1)+
	addq.l	#1,d6
	cmpi.l	#256,d6
	bcs.b	first_stage

	movea.l	#0,a6			;second stage of FFT
	lea	(-2048,a0),a0		;a0 points to the beginning of ReX buffer
	lea	(-2048,a1),a1		;a1 points to the beginning of ImX buffer
					;on the second stage we will calculate
					;two butterflies, first of which looks like
					;butterfly on the first stage
					;xr0 = ar0 + br0
					;xi0 = ai0 + bi0
					;yr0 = ar0 - br0
					;yi0 = ai0 - bi0,
					;and second looks like
					;xr1 = ar1 + bi1
					;xi1 = ai1 - br1
					;yr1 = ar1 - bi1
					;yi1 = ai1 + br1


second_stage:
	movem.l	(a0),d0-d3		;d0 = ar0, d1 = ar1, d2 = br0, d3 = br1
	movem.l	(a1),d4-d7		;d4 = ai0, d5 = ai1, d6 = bi0, d7 = bi1
	movea.l	d0,a2			;a2 = ar0
	movea.l	d1,a3			;a3 = ar1
	movea.l	d4,a4			;a4 = ai0
	movea.l	d5,a5			;a5 = ai1
	add.l	d2,d0			;xr0 = ar0 + br0
	move.l	d0,(a0)+
	add.l	d7,d1			;xr1 = ar1 + bi1
	move.l	d1,(a0)+
	suba.l	d2,a2			;yr0 = ar0 - br0
	move.l	a2,(a0)+
	suba.l	d7,a3			;yr1 = ar1 - bi1
	move.l	a3,(a0)+
	add.l	d6,d4			;xi0 = ai0 + bi0
	move.l	d4,(a1)+
	sub.l	d3,d5			;xi1 = ai1 - br1
	move.l	d5,(a1)+
	suba.l	d6,a4			;yi0 = ai0 - bi0
	move.l	a4,(a1)+
	adda.l	d3,a5			;yi1 = ai1 + br1
	move.l	a5,(a1)+
	addq.l	#1,a6;
	cmpa.l	#128,a6
	bcs.b	second_stage

	move.l	#64,d0			;fft for complex values
	move.l	d0,(64,a7)		;starts from 3-rd stage
	moveq.l	#2,d0
	move.l	d0,(68,a7)		;stage loop counter (starts from 3rd stage)
	movea.l	#16,a5			;a5 contains the number of butterflies
					;per one sub DFT multiplied
					;by 4 (the size of values)
	move.l	#1024,d6		;step in the table of twiddle factors
					;(multiplied by 4 because of the size
					;of coefficients)
	movea.l	#0,a6			;counter for butterfly loop

					;from MSW to LSW to store it correctly
					;into the memory)

 move.l		#0x00000030,MACSR
 
   	clr.l d2
   	clr.l d7
	move.l	#0,ACC0
	move.l  #0,ACC1

next_stage:				;start of stages loop
	moveq.l	#0,d0
	move.l	d0,(60,a7)		;sub DFT loop counter
	movem.l	(76,a7),a0-a1		;a0 points to ar0, a1 points to ai0
	movea.l	a0,a2
	movea.l	a1,a3
	adda.l	a5,a2			;a2 points to br0
	adda.l	a5,a3			;a3 points to bi0
next_subDFT:				;start of sub DFTs loop
	movea.l	#TF_table,a4		;a4 points to the first twiddle factor

//********************** NEXT_BF *********************************
	movem.l	(a4),d0-d1			;wr -> d0, wi -> d1
next_bf:						;start of butterflies loop

	adda.l	d6,a4

	move.l	(a0),d2			;ar -> d2
	move.l	(a2),d4			;br -> d4

	move.l	d2,ACC0				;ar -> ACC
	msacl.l	d0,d4,(a3),d5,ACC0		;ar-br*wr -> ACC, bi -> d5
	msacl.l	d1,d5,(a1),a6,ACC0		;ar-br*wr-bi*wi = xr -> ACC, ai -> a6
	macl.l	d1,d4,4(a4),d1,ACC1		;ai+br*wi -> ACC, ar -> d2
	msacl.l	d0,d5,(a4),d0,ACC1				;ai+br*wi-bi*wr = xi -> ACC, br -> d4


	movclr.l	ACC0,d3
	move.l	d3,(a0)+			;xr -> memory
	add.l	d2,d2				;2*ar -> d2
	sub.l	d3,d2				;2*ar-xr = yr -> d2


	movclr.l	ACC1,d3
	add.l	a6,d3				
	move.l	d2,(a2)+			;yr -> memory
	move.l	d3,(a1)+			;xi -> memory
	adda.l	a6,a6				;2*ai -> a6
	suba.l	d3,a6				;2*ai-xi = yi -> a6
	move.l	a6,(a3)+			;yi -> memory


	adda.l	d6,a4

	move.l	(a0),d2			;ar -> d2
	move.l	(a2),d4			;br -> d4

	move.l	d2,ACC0				;ar -> ACC
	msacl.l	d0,d4,(a3),d5,ACC0		;ar-br*wr -> ACC, bi -> d5
	msacl.l	d1,d5,(a1),a6,ACC0		;ar-br*wr-bi*wi = xr -> ACC, ai -> a6
	macl.l	d1,d4,4(a4),d1,ACC1		;ai+br*wi -> ACC, ar -> d2
	msacl.l	d0,d5,(a4),d0,ACC1				;ai+br*wi-bi*wr = xi -> ACC, br -> d4


	movclr.l	ACC0,d3
	move.l	d3,(a0)+			;xr -> memory
	add.l	d2,d2				;2*ar -> d2
	sub.l	d3,d2				;2*ar-xr = yr -> d2


	movclr.l	ACC1,d3
	add.l	a6,d3				
	move.l	d2,(a2)+			;yr -> memory
	move.l	d3,(a1)+			;xi -> memory
	adda.l	a6,a6				;2*ai -> a6
	suba.l	d3,a6				;2*ai-xi = yi -> a6
	move.l	a6,(a3)+			;yi -> memory


	addq.l	#8,d7
	cmp.l	a5,d7
	bcs	next_bf				;end of butterflies loop
								;of the current sub DFT
//********************** END OF NEXT_BF *********************************

	moveq.l	#0,d7
	adda.l	a5,a0			;a0 - a3 point to the input values
	adda.l	a5,a1			;for the first butterfly
	adda.l	a5,a2			;of the next sub DFT
	adda.l	a5,a3

	move.l	(60,a7),d0
	addq.l	#1,d0
	move.l	d0,(60,a7)		;increment sub DFT loop counter
	cmp.l	(64,a7),d0		;compare sub DFT loop counter with
					;the number of sub DFTs on this stage
	bcs.w	next_subDFT		;end of sub DFTs loop

	moveq.l	#0,d0
	move.l	d0,(60,a7)		;store 0 to the sub DFT loop counter
	adda.l	a5,a5			;multiply contents of a5 (the number of
					;butterflies per one sub DFT) by 2 for the
					;next stage
	lsr.l	#1,d6			;divide step in the table of twiddle
					;factors by 2
	move.l	(64,a7),d0		;divide the number of sub DFTs for the
	lsr.l	#1,d0			;next stage by 2
	move.l	d0,(64,a7)
	move.l	(68,a7),d0		;increment stage loop counter
	addq.l	#1,d0
	move.l	d0,(68,a7)
	cmpi.l	#9,d0
	bcs.w	next_stage		;end of stage loop

;even/odd frequency domain decomposition	
;Corresponding C code:
	;nm1=smpl_num-1;
	;nd2=smpl_num>>1;
	;n4=(smpl_num>>2);
	;for (i=1;i<n4;i++){
	;    im=nd2-i;
	;    ip2=i+nd2;
	;    ipm=im+nd2;
	;
	;    ReX[ip2]=(ImX[i]+ImX[im])/2;
	;    ReX[ipm]=ReX[ip2];
	;
	;    ImX[ip2]=(ReX[im]-ReX[i])/2;
	;    ImX[ipm]=-ImX[ip2];
	;
	;    ReX[i]=(ReX[i]+ReX[im])/2;
	;    ReX[im]=ReX[i];
	;
	;    ImX[i]=(ImX[i]-ImX[im])/2;
	;    ImX[im]=-ImX[i];
	;}
	;n34=(smpl_num*3)>>2;
	;ReX[n34]=ImX[n4];
	;ReX[nd2]=ImX[0];
	;ImX[n34]=0;
	;ImX[nd2]=0;
	;ImX[n4]=0;
	;ImX[0]=0;

	movem.l	(76,a7),a0/a1		;even/odd frequency domain decomposition
	lea	(4,a0),a2
	lea	(4,a1),a3
	lea	(2048,a0),a4
	lea	(2048,a1),a5
	lea	(2052,a0),a6
	move.l	#2052,d0
	move.l	#4092,d6
adjust:	move.l	(a3),d3			;d3 = ImX[i]
	move.l	d3,d1			;d1 = ImX[i]
	move.l	-(a5),d5		;d5 = ImX[im]
	add.l	d5,d3			;d3 = ImX[i] + ImX[im]
	asr.l	#1,d3			;d3 = (ImX[i] + ImX[im]) / 2
	move.l	d3,(a6)+		;ReX[ip2] = d3
	move.l	d3,(a0,d6.l)		;ReX[ipm] = ReX[ip2]
	move.l	-(a4),d4		;d4 = ReX[im]
	move.l	d4,d7			;d7 = ReX[im]
	move.l	(a2),d2			;d2 = ReX[i]
	sub.l	d2,d4			;d4 = ReX[im] - ReX[i]
	asr.l	#1,d4			;d4 = (ReX[im] - ReX[i]) / 2
	move.l	d4,(a1,d0.l)		;ImX[ip2] = d4
	neg.l	d4			;d4 = -d4
	move.l	d4,(a1,d6.l)		;ImX[ipm] = -ImX[ip2]
	add.l	d7,d2			;d2 = ReX[i] + ReX[im]
	asr.l	#1,d2			;d2 = (ReX[i] + ReX[im]) / 2
	move.l	d2,(a2)+		;ReX[i] = d2
	move.l	d2,(a4)			;ReX[im] = ReX[i]
	sub.l	d5,d1			;d1 = ImX[i] - ImX[im]
	asr.l	#1,d1			;d1 = (ImX[i] - ImX[im]) / 2
	move.l	d1,(a3)+		;ImX[i] = d1
	neg.l	d1			;d1 = -d1
	move.l	d1,(a5)			;ImX[im]=-ImX[i];
	addq.l	#4,d0			;loop processing
	subq.l	#4,d6
	cmpi.l	#3072,d0
	bcs.b	adjust
	moveq.l	#0,d0
	move.l	(1024,a1),(3072,a0)	;ReX[n34]=ImX[n4];
	move.l	(a1),(2048,a0)		;ReX[nd2]=ImX[0];
	move.l	d0,(3072,a1)		;ImX[n34]=0;
	move.l	d0,(2048,a1)		;ImX[nd2]=0;
	move.l	d0,(1024,a1)		;ImX[n4]=0;
	move.l	d0,(a1)			;ImX[0]=0;

	movea.l	#2048,a5		;the 10th stage of FFT
	movea.l	#TF_table,a4		;a4 points to the first twiddle factor
	movea.l	a0,a2			;a0 points to ar0
	movea.l	a1,a3			;a1 points to ai0
	adda.l	a5,a2			;a2 points to br0
	adda.l	a5,a3			;a3 points to bi0
	move.l	(a0),d2			;ar -> d2
	move.l	(a2),d4			;br -> d4
	moveq.l	#0,d7			;counter for butterfly loop

	movem.l	(a4),d0-d1			;wr -> d0, wi -> d1

/*	movem.l	(a7),d0-d7/a0-a6
	lea	+72(a7),a7
        rts*/


fin_stage:
	adda.l	#8,a4

	move.l	(a0),d2			;ar -> d2
	move.l	(a2),d4			;br -> d4

	move.l	d2,ACC0				;ar -> ACC
	msacl.l	d0,d4,(a3),d5,ACC0		;ar-br*wr -> ACC, bi -> d5
	msacl.l	d1,d5,(a1),a6,ACC0		;ar-br*wr-bi*wi = xr -> ACC, ai -> a6
	macl.l	d1,d4,4(a4),d1,ACC1		;ai+br*wi -> ACC, ar -> d2
	msacl.l	d0,d5,(a4),d0,ACC1				;ai+br*wi-bi*wr = xi -> ACC, br -> d4


	movclr.l	ACC0,d3
	move.l	d3,(a0)+			;xr -> memory
	add.l	d2,d2				;2*ar -> d2
	sub.l	d3,d2				;2*ar-xr = yr -> d2


	movclr.l	ACC1,d3
	add.l	a6,d3				
	move.l	d2,(a2)+			;yr -> memory
	move.l	d3,(a1)+			;xi -> memory
	adda.l	a6,a6				;2*ai -> a6
	suba.l	d3,a6				;2*ai-xi = yi -> a6
	move.l	a6,(a3)+			;yi -> memory


	adda.l	#8,a4

	move.l	(a0),d2			;ar -> d2
	move.l	(a2),d4			;br -> d4

	move.l	d2,ACC0				;ar -> ACC
	msacl.l	d0,d4,(a3),d5,ACC0		;ar-br*wr -> ACC, bi -> d5
	msacl.l	d1,d5,(a1),a6,ACC0		;ar-br*wr-bi*wi = xr -> ACC, ai -> a6
	macl.l	d1,d4,4(a4),d1,ACC1		;ai+br*wi -> ACC, ar -> d2
	msacl.l	d0,d5,(a4),d0,ACC1				;ai+br*wi-bi*wr = xi -> ACC, br -> d4


	movclr.l	ACC0,d3
	move.l	d3,(a0)+			;xr -> memory
	add.l	d2,d2				;2*ar -> d2
	sub.l	d3,d2				;2*ar-xr = yr -> d2


	movclr.l	ACC1,d3
	add.l	a6,d3				
	move.l	d2,(a2)+			;yr -> memory
	move.l	d3,(a1)+			;xi -> memory
	adda.l	a6,a6				;2*ai -> a6
	suba.l	d3,a6				;2*ai-xi = yi -> a6
	move.l	a6,(a3)+			;yi -> memory


	addq.l	#8,d7
	cmp.l	a5,d7
	bcs.b	fin_stage		;end of butterfly loop

	movem.l	(a7),d0-d7/a0-a6
	lea	+72(a7),a7
        rts

;******************************************************************************
;Inversed Real FFT
;******************************************************************************
;Upon entry, ReX[ ] and ImX[ ] contain the real and imaginary parts of the
;frequency domain running from index 0 to 512. The remaining samples in
;ReX[ ] and ImX[ ] are ignored.
;Upon return, ReX[ ] contains the real time domain.
;******************************************************************************
_inv_fft32_emac:
;make frequency domain symmetrical
;Corresponding C code:
	;n=smpl_num;
	;for (i=((n>>1)+1);i<n;i++){
	;    ReX[i]=ReX[n-i];
	;    ImX[i]=-ImX[n-i];
	;}

	moveq.l	#0,d1				;make frequency domain
	movem.l	(4,a7),a0-a1			;symmetrical
	lea	(2048,a0),a2
	lea	(2048,a1),a3
	lea	(2052,a0),a0
	lea	(2052,a1),a1
movneg:
	move.l	-(a2),(a0)+			;ReX[i]=ReX[n-i];
	move.l	-(a3),d0
	neg.l	d0
	move.l	d0,(a1)+			;ImX[i]=-ImX[n-i];
	addq.l	#1,d1				;loop processing
	cmp.l	#511,d1
	bcs.b	movneg

;add real and imaginary parts together
;Corresponding C code:
	;for (i=0;i<n;i++){
	;    ReX[i]=ReX[i]+ImX[i];
	;}

	moveq.l	#0,d0				;add real and imaginary parts
	movem.l	(4,a7),a0-a1			;together
sum:
	move.l	(a0),d1				;d1 = ReX[i]
	add.l	(a1)+,d1			;d1 = d1 + ImX[i]
	move.l	d1,(a0)+			;ReX[i] = d1	
	addq.l	#1,d0				;loop processing
	cmp.l	#1024,d0
	bcs.b	sum

	move.l	(8,a7),-(a7)			;calculate forward real FFT
	move.l	(8,a7),-(a7)
	jsr	_fft32_emac
	addq.l	#8,a7

;add real and imaginary parts together
;Corresponding C code:
;for (i=0;i<n;i++){
;    ReX[i]=(ReX[i]+ImX[i])/n;
;}

	moveq.l	#0,d0				;add real and imaginary parts
	movem.l	(4,a7),a0-a1			;together
norm:
	move.l	(a0),d1				;d1 = ReX[i]
	add.l	(a1)+,d1			;d1 = d1 + ImX[i]
;	asr.l	#8,d1
	asr.l	#1,d1				;d1 = d1 / 2
	move.l	d1,(a0)+			;ReX[i] = d1
	addq.l	#1,d0				;loop processing
	cmp.l	#1024,d0
	bcs.b	norm
	rts
